/**
 * @name		jQuery Countdown Plugin
 * @author		Martin Angelov
 * @version 	1.0
 * @url			http://tutorialzine.com/2011/12/countdown-jquery/
 * @license		MIT License
 */



$(function() {
      var currentDate = new Date(),
          finished = false,
          availiableExamples = {
            set3daysFromNow : 3 * 24 * 60 * 60 * 1000,
            set2daysFromNow : 2 * 24 * 60 * 60 * 1000,
            set5minFromNow  : 5 * 60 * 1000,
            set1minFromNow  : 1 * 60 * 1000
          };
      var d, h, m, s;
      
      function callback(event) {
        var timeFormat = "%d day(s) %h:%m:%s"
            $this = $(this);
        if(finished) {
          $this.fadeTo(0, 1);
          finished = false;
        }
        switch(event.type) {
          case "days":
            d = event.value;
            break;
          case "hours":
            h = event.value;
            break;
          case "minutes":
            m = event.value;
            break;
          case "seconds":
            s = event.value;
            break;
          case "finished":
            $this.fadeTo('slow', 0.5);
            finished = true;
            break;
        }
        // Assemble time format
        if(d > 0) {
          timeFormat = timeFormat.replace(/\%d/, d);
          timeFormat = timeFormat.replace(/\(s\)/, Number(d) == 1 ? '' : 's');
        } else {
          timeFormat = timeFormat.replace(/\%d day\(s\)/, '');
        }
		
        timeFormat = timeFormat.replace(/\%h/, h);
        timeFormat = timeFormat.replace(/\%m/, m);
        timeFormat = timeFormat.replace(/\%s/, s);
        // Display
       // $this.html(d);
	   $(".time_days").text(d);
	   $(".time_hours").text(h);
	   $(".time_minutes").text(m);
	   $(".time_seconds").text(s);
      }
      
  		//$('div#clock').countdown(availiableExamples.set1minFromNow + currentDate.valueOf(), callback);

  		$('div#clock').countdown(countdown_value, callback);
  	});

	
/*
 * jQuery The Final Countdown plugin v1.0.0 beta
 * http://github.com/hilios/jquery.countdown
 *
 * Copyright (c) 2011 Edson Hilios
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
(function($) {
  
  $.fn.countdown = function(toDate, callback) {
    var handlers = ['seconds', 'minutes', 'hours', 'days', 'weeks', 'daysLeft'];
    
    function delegate(scope, method) {
      return function() { return method.call(scope) }
    }
    
    return this.each(function() {
      // Convert
      if(!(toDate instanceof Date)) {
        if(String(toDate).match(/^[0-9]*$/)) {
          toDate = new Date(toDate);
        } else if( toDate.match(/([0-9]{1,2})\/([0-9]{1,2})\/([0-9]{2,4})\s([0-9]{1,2})\:([0-9]{2})\:([0-9]{2})/) ||
            toDate.match(/([0-9]{2,4})\/([0-9]{1,2})\/([0-9]{1,2})\s([0-9]{1,2})\:([0-9]{2})\:([0-9]{2})/)
            ) {
          toDate = new Date(toDate);
        } else if(toDate.match(/([0-9]{1,2})\/([0-9]{1,2})\/([0-9]{2,4})/) || 
                  toDate.match(/([0-9]{2,4})\/([0-9]{1,2})\/([0-9]{1,2})/)
                  ) {
          toDate = new Date(toDate)
        } else {
          throw new Error("Doesn't seen to be a valid date object or string")
        }
      }
      
      var $this = $(this),
          values = {},
          lasting = {},
          interval = $this.data('countdownInterval'),
          currentDate = new Date(),
          secondsLeft = Math.floor((toDate.valueOf() - currentDate.valueOf()) / 1000);
      
      function triggerEvents() {
        // Evaluate if this node is included in the html
        if($this.closest('html').length === 0) {
          stop(); // Release the memory
          dispatchEvent('removed');
          return;
        }
        // Calculate the time offset
        secondsLeft--;
        if(secondsLeft < 0) {
          secondsLeft = 0;
        }
        lasting = {
          seconds : secondsLeft % 60,
          minutes : Math.floor(secondsLeft / 60) % 60,
          hours   : Math.floor(secondsLeft / 60 / 60) % 24,
          days    : Math.floor(secondsLeft / 60 / 60 / 24),
          weeks   : Math.floor(secondsLeft / 60 / 60 / 24 / 7),
          daysLeft: Math.floor(secondsLeft / 60 / 60 / 24) % 7
        }
        for(var i=0; i<handlers.length; i++) {
          var eventName = handlers[i];
          if(values[eventName] != lasting[eventName]) {
            values[eventName] = lasting[eventName];
            dispatchEvent(eventName);
          }
        }
        if(secondsLeft == 0) { 
          stop();
		 
          dispatchEvent('finished');
		   $this.html(countdown_finish)
        }
      }
	  
      triggerEvents();
      
      function dispatchEvent(eventName) {
        var event     = $.Event(eventName);
        event.date    = new Date(new Date().valueOf() + secondsLeft);
        event.value   = values[eventName] || "0";
        event.toDate  = toDate;
        event.lasting = lasting;
        switch(eventName) {
          case "seconds":
          case "minutes":
          case "hours":
            event.value = event.value < 10 ? '0'+event.value.toString() : event.value.toString();
            break;
          default:
            if(event.value) {
              event.value = event.value.toString();
            }
            break;
        }
        callback.call($this, event);
      }
      
      function stop() {
        clearInterval(interval);
      }

      function start() {
        $this.data('countdownInterval', setInterval(delegate($this, triggerEvents), 1000));
        interval = $this.data('countdownInterval');
      }
      
      if(interval) stop();
      start();
    });
  }
})(jQuery);


	
		
